//#######################################################################################################################
//#
//#	 - , ,   ..
//#
//#######################################################################################################################


// 
#define F_CPU 8000000
#include <util/delay.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h> 						//eeprom_read_byte(), eeprom_write_byte(), eeprom_read_word(), eeprom_write_word()
#include <avr/pgmspace.h>


//-----------------------------------------------------------------------------------------------------------------------
//
#define INLINE   inline __attribute__((__always_inline__))
#define NOINLINE __attribute__((__noinline__))

#define LedBoardRowInvert	0				/*0-  , 255-  ULN2303*/
#define	LedBoardSize 		8					/*     ( )*/
#define LedBoardSimbWidth 	6					/*   ,   */
#define FontSimbWidth 		5					/*   ,   */
#define TimeOutConst 		60					/*  - ,   ,    -*/


//-----------------------------------------------------------------------------------------------------------------------
//  
//  ,    ,     
//(      )
//EEARL - 	EEPROM  
//EEDR - 	EEPROM  
//UBRRL - 	USART   
//TWBR -	TWI   
//TWAR - 	TWI  
	
#define Flags1   TWBR							/*  1     EEARL (..  EEPROM  -)*/
	#define b1LedBoardPageCompleted	(1<<0)		/*  */
	#define b1OneWireGet			(1<<1)		/*       1wire */
	#define b1ClockReadEnable		(1<<2)		/*      */
	#define b1ClockChange			(1<<3)		/*   */

#define BtnFlags   TWAR							/*       EEDR (..  EEPROM  -)*/
	#define ShortUp			(1<<0)				/*    */ 
	#define ShortLeft		(1<<1)				/*    */ 
	#define ShortRight		(1<<2)				/*    */ 
	#define ShortDown		(1<<3)				/*    */ 
	#define LongUp			(1<<4)				/*    */ 
	#define LongLeft		(1<<5)				/*    */ 
	#define LongRight		(1<<6)				/*    */ 
	#define LongDown		(1<<7)				/*    */ 

volatile uint8_t BtnLongSpeed;							//     
volatile char BtnTimeOutCoun;							//     TimeOut-

char LedBoardBuffer [(LedBoardSize+2)*LedBoardSimbWidth];//     
char LedBoardHorScrollSpeed = 30;						//    (1-100 \)
char LedBoardVertScrollSpeed = 15;						//    (1-100 \)
char LedBoardFlashCoun = 0;								//   FLASH ( 0-99  )

char ClockSimbVertScrollSpeed = 6;						//      (12- ..... 1-)
char ClockMiliSecond;									//  (  )
char ClockData [7] =									//    ( - )
	{0x00,0x00,0x00,0x01,0x01,0x01,0x12};				//, , , , , , 
char ClockGraphBuf [LedBoardSimbWidth*8];				//     8 
int  ClockPosition = 0;									//     (0- , 1- 1  , 2-2,  ..)
char ClockChangeMask = 0;								//    (   )
							
char OneWireErr;										//  1wire 
char OneWireCheckSumm;									//     1wire
char OneWireReadBuf [9];								//  1wire (  )
int  OneWireTermoData [2];								//   (2   2 )


//-----------------------------------------------------------------------------------------------------------------------
// 	
static void LedBoardIntPrint (signed int integer, uint8_t IntPos, uint8_t IntLength, uint8_t DotPosition);
static void LedBoardSimbPrint (unsigned char simbol, unsigned char position);
static void LedBoardMessageShow (char *pAdrTxt);
static void LedBoardMessageScrollLeft (char *pAdrTxt);
static void LedBoardTermoShow (char Position, uint8_t NumDev);
static void LedBoardTermoScrollLeft (uint8_t NumDev);
static void LedBoardClockShow (uint8_t Position);
static void LedBoardClockScrollLeft (void);
static void LedBoardClearScrollLeft (void);
static void LedBoardClearScrollDown (void);
static void LedBoard1PixScrollLeft (void);
static void LedBoardOut (char NumLine);

static void IICStart (void);					//  I2C
static void IICStop (void);

static void IICClockReadData (void);			//-     DS1307
static void IICClockWriteData (void);

static void ClockBufferProcess (void);
static void ClockSimbToBuf (char byte, char Shift);

static char IICByteWrite (char);
static char IICByteRead (char);
static char IICBit (char);

static uint8_t OneWireData (uint8_t, char);
static void OneWireIntTermoGet (void);
static void OneWireReset (char);
static void CheckSumm (char);

static void Delay (unsigned char);
static void VarProcessing (void);
static void MainInit (void);


static void BtnGet (void);						//-  


//-----------------------------------------------------------------------------------------------------------------------
//  PROGRAM MEMORY					
char SimbMass [] PROGMEM = {							// 
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFA,0x00,0x00,	// !
	0x00,0xC0,0x00,0xC0,0x00,0x28,0xFE,0x28,0xFE,0x28,	//"#
	0x24,0x54,0xFE,0x54,0x48,0xC4,0xC8,0x10,0x26,0x46,	//$%
	0x6C,0x92,0xAA,0x44,0x0A,0x00,0xA0,0xC0,0x00,0x00,	//&'
	0x00,0x38,0x44,0x82,0x00,0x00,0x82,0x44,0x38,0x00,	//()
	0x28,0x10,0x7C,0x10,0x28,0x10,0x10,0x7C,0x10,0x10,	//*+
	0x00,0x05,0x06,0x00,0x00,0x10,0x10,0x10,0x10,0x10,	//,-
	0x00,0x06,0x06,0x00,0x00,0x04,0x08,0x10,0x20,0x40,	//./
	0x7C,0x8A,0x92,0xA2,0x7C,0x00,0x42,0xFE,0x02,0x00,	//01
	0x42,0x86,0x8A,0x92,0x62,0x84,0x82,0xA2,0xD2,0x8C,	//23
	0x18,0x28,0x48,0xFE,0x08,0xE4,0xA2,0xA2,0xA2,0x9C,	//45
	0x3C,0x52,0x92,0x92,0x0C,0xC0,0x80,0x8E,0x90,0xE0,	//67
	0x6C,0x92,0x92,0x92,0x6C,0x60,0x92,0x92,0x94,0x78,	//89
	0x00,0x6C,0x6C,0x00,0x00,0x00,0x6A,0x6C,0x00,0x00,	//:;
	0x10,0x28,0x44,0x82,0x00,0x28,0x28,0x28,0x28,0x28,	//<=
	0x00,0x82,0x44,0x28,0x10,0x40,0x80,0x8A,0x90,0x60,	//>?
	0x4C,0x92,0x9E,0x82,0x7C,0x7E,0x88,0x88,0x88,0x7E,	//@A
	0xFE,0x92,0x92,0x92,0x6C,0x7C,0x82,0x82,0x82,0x44,	//BC
	0xFE,0x82,0x82,0x44,0x38,0xFE,0x92,0x92,0x92,0x82,	//DE
	0xFE,0x90,0x90,0x90,0x80,0x7C,0x82,0x92,0x92,0x5E,	//FG
	0xFE,0x10,0x10,0x10,0xFE,0x00,0x82,0xFE,0x82,0x00,	//HI
	0x04,0x02,0x82,0xFC,0x80,0xFE,0x10,0x28,0x44,0x82,	//JK
	0xFE,0x02,0x02,0x02,0x02,0xFE,0x40,0x30,0x40,0xFE,	//LM
	0xFE,0x20,0x10,0x08,0xFE,0x7C,0x82,0x82,0x82,0x7C,	//NO
	0xFE,0x90,0x90,0x90,0x60,0x7C,0x82,0x8A,0x84,0x7A,	//PQ
	0xFE,0x90,0x98,0x94,0x62,0x62,0x92,0x92,0x92,0x8C,	//RS
	0x80,0x80,0xFE,0x80,0x80,0xFC,0x02,0x02,0x02,0xFC,	//TU
	0xF8,0x04,0x02,0x04,0xF8,0xFC,0x02,0x1C,0x02,0xFC,	//VW
	0xC6,0x28,0x10,0x28,0xC6,0xE0,0x10,0x0E,0x10,0xE0,	//XY
	0x86,0x8A,0x92,0xA2,0xC2,0xFE,0x82,0x82,0x00,0x00,	//Z[
	0xA8,0x68,0x3E,0x68,0xA8,0x00,0x82,0x82,0xFE,0x00,	//\]
	0x20,0x40,0x80,0x40,0x20,0x02,0x02,0x02,0x02,0x00,	//^_
	0x00,0x60,0x90,0x60,0x00,0x04,0x2A,0x2A,0x2A,0x1E,	//`a
	0xFE,0x12,0x22,0x22,0x1C,0x1C,0x22,0x22,0x22,0x04,	//bc
	0x1C,0x22,0x22,0x12,0xFE,0x1C,0x2A,0x2A,0x2A,0x18,	//de
	0x10,0x7E,0x90,0x80,0x40,0x30,0x4A,0x4A,0x4A,0x7C,	//fg
	0xFE,0x10,0x20,0x20,0x1E,0x00,0x22,0xBE,0x02,0x00,	//hi
	0x04,0x02,0x22,0xBC,0x00,0xFE,0x08,0x14,0x22,0x00,	//jk
	0x00,0x82,0xFE,0x02,0x00,0x3E,0x20,0x18,0x20,0x1E,	//lm
	0x3E,0x10,0x20,0x20,0x1E,0x1C,0x22,0x22,0x22,0x1C,	//no
	0x3E,0x28,0x28,0x28,0x10,0x10,0x28,0x28,0x18,0x3E,	//pq
	0x3E,0x10,0x20,0x20,0x10,0x12,0x2A,0x2A,0x2A,0x04,	//rs
	0x20,0xFC,0x22,0x02,0x04,0x3C,0x02,0x02,0x04,0x3E,	//tu
	0x38,0x04,0x02,0x04,0x38,0x3C,0x02,0x1C,0x02,0x3C,	//vw
	0x22,0x14,0x08,0x14,0x22,0x30,0x0A,0x0A,0x0A,0x3C,	//xy
	0x22,0x26,0x2A,0x32,0x22,0x00,0x10,0x6C,0x82,0x00,	//z{
	0x00,0x00,0xFE,0x00,0x00,0x00,0x82,0x6C,0x10,0x00,	//|}
	0x10,0x10,0x54,0x38,0x10,0x10,0x38,0x54,0x10,0x10,	//~
	0x7E,0x88,0x88,0x88,0x7E,0xFE,0x92,0x92,0x92,0xCC,	//
	0xFE,0x92,0x92,0x92,0x6C,0xFE,0x80,0x80,0x80,0xC0,	//
	0x07,0x8A,0xF2,0x82,0xFF,0xFE,0x92,0x92,0x92,0x82,	//
	0xEE,0x10,0xFE,0x10,0xEE,0x82,0x92,0x92,0x92,0x7C,	//
	0xFE,0x08,0x10,0x20,0xFE,0x3E,0x84,0x48,0x90,0x3E,	//
	0xFE,0x10,0x28,0x44,0x82,0x04,0x82,0xFC,0x80,0xFE,	//
	0xFE,0x40,0x30,0x40,0xFE,0xFE,0x10,0x10,0x10,0xFE,	//
	0x7C,0x82,0x82,0x82,0x7C,0xFE,0x80,0x80,0x80,0xFE,	//
	0xFE,0x90,0x90,0x90,0x60,0x7C,0x82,0x82,0x82,0x44,	//
	0x80,0x80,0xFE,0x80,0x80,0xE2,0x14,0x08,0x10,0xE0,	//
	0x38,0x44,0xFE,0x44,0x38,0xC6,0x28,0x10,0x28,0xC6,	//
	0xFC,0x04,0x04,0x04,0xFE,0xE0,0x10,0x10,0x10,0xFE,	//
	0xFE,0x02,0xFE,0x02,0xFE,0xFC,0x04,0xFC,0x04,0xFE,	//
	0x80,0xFE,0x12,0x12,0x0C,0xFE,0x12,0x0C,0x00,0xFE,	//
	0xFE,0x12,0x12,0x12,0x0C,0x44,0x82,0x92,0x92,0x7C,	//
	0xFE,0x10,0x7C,0x82,0x7C,0x62,0x94,0x98,0x90,0xFE,	//
	0x04,0x2A,0x2A,0x2A,0x1E,0x3C,0x52,0x52,0x92,0x8C,	//
	0x3E,0x2A,0x2A,0x2A,0x14,0x3E,0x20,0x20,0x20,0x30,	//
	0x27,0x2A,0x32,0x22,0x3F,0x1C,0x2A,0x2A,0x2A,0x18,	//
	0x36,0x08,0x3E,0x08,0x36,0x22,0x22,0x2A,0x2A,0x14,	//
	0x3E,0x04,0x08,0x10,0x3E,0x1E,0x42,0x24,0x48,0x1E,	//
	0x3E,0x08,0x14,0x22,0x00,0x04,0x22,0x3C,0x20,0x3E,	//
	0x3E,0x10,0x08,0x10,0x3E,0x3E,0x08,0x08,0x08,0x3E,	//
	0x1C,0x22,0x22,0x22,0x1C,0x3E,0x20,0x20,0x20,0x3E,	//
	0x3E,0x28,0x28,0x28,0x10,0x1C,0x22,0x22,0x22,0x04,	//
	0x20,0x20,0x3E,0x20,0x20,0x30,0x0A,0x0A,0x0A,0x3C,	//
	0x18,0x24,0x7E,0x24,0x18,0x22,0x14,0x08,0x14,0x22,	//
	0x3C,0x04,0x04,0x04,0x3E,0x30,0x08,0x08,0x08,0x3E,	//
	0x3E,0x02,0x3E,0x02,0x3E,0x3E,0x02,0x3E,0x02,0x3F,	//
	0x20,0x3E,0x0A,0x0A,0x04,0x3E,0x0A,0x04,0x00,0x3E,	//
	0x3E,0x0A,0x0A,0x04,0x00,0x14,0x22,0x2A,0x2A,0x1C,	//
	0x3E,0x08,0x1C,0x22,0x1C,0x10,0x2A,0x2C,0x28,0x3E	//
};			
							

char DSReadingMap [] PROGMEM = {// ,      
	0x0D,0x33,0x00,0x0D,0xCC,0xBE,0x01,0x02,0x0C,0x0C,0x03,0x0C,0x0C,0x0C,0x0C,0x0B,
	0x0D,0x33,0x04,0x0D,0xCC,0xBE,0x05,0x06,0x0C,0x0C,0x07,0x0C,0x0C,0x0C,0x0C,0x0E,
	0x0D,0xCC,0x44,0x0F
};


//-----------------------------------------------------------------------------------------------------------------------
//  
 void MainInit (void)
{

	//  LedBoard
	#define LedBoardRowPORT 	PORTD				/* */
	#define LedBoardRowDDR 		DDRD				/*  */
	#define LedBoardDataPORT 	PORTB				/* */
	#define LedBoardDataDDR 	DDRB				/*  */
	#define LedBoardData 		(1<<6)				/* */
	#define LedBoardClc 		(1<<7)				/* */
	#define LedBoardStrobe 		(1<<5)				/* */
	#define LedBoardOn	 		(1<<4)				/*  */

	LedBoardRowDDR = 0xFF;							//     
	LedBoardDataDDR |= LedBoardData|LedBoardClc		//
	|LedBoardStrobe|LedBoardOn;

	//  
	#define BtnPORT 			PORTC				/* */
	#define BtnDDR 				DDRC				/*  */
	#define BtnPIN 				PINC				/*  */
	#define Button1				(1<<2)				/* 1*/
	#define Button2				(1<<3)				/* 2*/
	#define Button3				(1<<4)				/* 3*/
	#define Button4				(1<<5)				/* 4*/

	BtnPORT |= Button1|Button2|Button3|Button4;		//  

	//  IIC
	#define IICDDR				DDRC				/*  I2C*/
	#define IICPORT				PORTC				/*     I2C*/
	#define IICPIN				PINC				/*     I2C*/
	#define IICData				(1<<0)				/* DATA*/
	#define IICClc				(1<<1)				/* CLC*/

	//  1WIRE
	#define OneWireDDR			DDRB				/*   1,2*/
	#define OneWirePORT			PORTB				/*   1,2*/
	#define OneWirePIN			PINB				/*   1,2*/
	#define OneWireLine1 		(1<<0)				/*  1*/
	#define OneWireLine2 		(1<<1)				/*  2*/

	//    .....
	DDRB  |= 0x0c;								

	//    
	TIMSK = 0x80;	 							//  -   
	TCCR2 = 0x0e;								//  T2 = CTC (0x08   )(0x06   256)
	OCR2  = 38;									//  (    .  38,  = 800Hz) 

	Flags1 = 0;									//  - 
	BtnFlags = 0;

	sei ();										//  

	LedBoardDataPORT |= LedBoardOn;				//  LedBoard
	Flags1 |= b1ClockReadEnable;				// 
}


//#######################################################################################################################
//#
//#	!  
//#
//#######################################################################################################################

